/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8238;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8238.MibInfo;
import ibm.nways.jdm8238.MstDecoder;
import ibm.nways.jdm8238.SummaryInfoLike;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public final class Jdm8238SummaryInfo
implements SummaryInfoLike {
    private GenModel deviceModel;
    private MibInfo mibInfo;
    public static final int MODEL_8238 = 0;
    public static final int MODEL_UNKNOWN = -1;
    private int hubModel = -1;
    private static final String[] sysOidTranslationTable = new String[]{"1.3.6.1.4.1.49.2.3.15"};
    private static final int[] modelTranslationTable = new int[1];

    public static int modelFromSysOid(String string) {
        if (string.equals("1.3.6.1.4.1.49.2.3.15")) {
            return 0;
        }
        return -1;
    }

    protected void finalize() throws Throwable {
        this.deviceModel = null;
        this.mibInfo = null;
    }

    public void dispose() {
        this.deviceModel = null;
        this.mibInfo = null;
    }

    public final void setMibInfo(MibInfo mibInfo) {
        this.mibInfo = mibInfo;
    }

    public final void setDeviceModel(GenModel genModel) {
        this.deviceModel = genModel;
    }

    public final void initialize() {
        Serializable serializable = this.mibInfo.getVar("sysOid");
        if (serializable instanceof SpecialValue) {
            this.mibInfo.setErrorCode(1);
            return;
        }
        String string = serializable.toString();
        if (RAS.isEnabled(19, 5)) {
            RAS.trace(19, 5, this, "initialize", "Hub SysObjectID -> " + string);
        }
        this.hubModel = Jdm8238SummaryInfo.modelFromSysOid(string);
        if (this.hubModel == -1) {
            this.mibInfo.setErrorCode(2);
            return;
        }
        this.refresh();
    }

    public final void refresh() {
        this.mibInfo.clearSummaryInfo();
        this.refreshMst();
    }

    private final void refreshMst() {
        try {
            MstDecoder mstDecoder = new MstDecoder();
            mstDecoder.setMibInfo(this.mibInfo);
            GenModel genModel = (GenModel)this.deviceModel.getComponent("MST");
            Vector vector = genModel.getRestOfInfo("Panel", "default", null, null);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
                Serializable serializable = modelInfo.get("Index.ModSummarySlotIndex");
                Serializable serializable2 = modelInfo.get("Panel.ModSummaryInfo");
                if (!(serializable2 instanceof OctetString)) continue;
                OctetString octetString = (OctetString)serializable2;
                int n = (Integer)serializable;
                boolean bl = mstDecoder.decode(octetString.value, n);
                if (bl) continue;
                this.mibInfo.setErrorCode(3);
            }
            vector = null;
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 5, this, "refreshMst", exception);
            return;
        }
    }
}

